<?php

namespace Elementor;

class goto_team_member extends Widget_Base {

    public function get_categories() {
        return array( 'goto-theme' );
    }

    public function get_name() {
        return 'team-member';
    }

    public function get_title() {
        return esc_html__( 'Team Member', 'goto' );
    }

    public function get_icon() {
        return 'eicon-person';
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_content',
            [
                'label' => esc_html__( 'Content', 'goto' ),
            ]
        );

        $this->add_control(
            'widget_image',
            [
                'label'   => esc_html__( 'Image Member', 'goto' ),
                'type'    => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'widget_name_member',
            [
                'label'         =>  esc_html__( 'Name', 'goto' ),
                'type'          =>  Controls_Manager::TEXT,
                'default'       =>  esc_html__( 'Name Member', 'goto' ),
                'label_block'   =>  false,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $this->add_control(
            'widget_position_member',
            [
                'label'         =>  esc_html__( 'Position', 'goto' ),
                'type'          =>  Controls_Manager::TEXT,
                'default'       =>  esc_html__( 'COO', 'goto' ),
                'label_block'   =>  false
            ]
        );

        $this->add_responsive_control( 'info_align', array(
            'type'    => Controls_Manager::CHOOSE,
            'label'   => esc_html__( 'Alignment', 'goto' ),
            'options' => array(
                'left' => array(
                    'title' => esc_html__( 'Left', 'goto' ),
                    'icon'  => 'fa fa-align-left'
                ),
                'center' => array(
                    'title' => esc_html__( 'Center', 'goto' ),
                    'icon'  => 'fa fa-align-center'
                ),
                'right' => array(
                    'title' => esc_html__( 'Right', 'goto' ),
                    'icon'  => 'fa fa-align-right'
                ),
            ),
            'default'        => 'left',
            'tablet_default' => 'left',
            'mobile_default' => 'left',
            'selectors'      => array(
                '{{WRAPPER}} .element-team-member' => 'text-align: {{VALUE}};'
            ),
        ));

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $img      = $settings['widget_image'];
        $img_alt  = goto_img_alt( $img['id'], esc_attr__( 'Team member image', 'goto' ) );
        ?>
        <div class="element-team-member">
            <div class="element-team-member__image">
                <img src="<?php echo esc_url( $img['url'] ); ?>" alt="<?php echo esc_attr( $img_alt ); ?>">
            </div>

            <div class="element-team-member__content">
                <h3 class="element-team-member__name">
                    <?php echo esc_html( $settings['widget_name_member'] ); ?>
                </h3>
                <p>
                    <?php echo esc_html( $settings['widget_position_member'] ); ?>
                </p>
            </div>
        </div>
    <?php
    }

    protected function _content_template() {
    ?>
        <div class="element-team-member">
            <div class="element-team-member__image">
                <img src="{{ settings.widget_image.url }}">
            </div>

            <div class="element-team-member__content">
                <h3 class="element-team-member__name">
                    {{{ settings.widget_name_member }}}
                </h3>
                <p>
                    {{{ settings.widget_position_member }}}
                </p>
            </div>
        </div>

    <?php

    }

}

Plugin::instance()->widgets_manager->register_widget_type( new goto_team_member() );